import 'package:admin_desktop/app_constants.dart';
import 'package:admin_desktop/presentation/components/header_item.dart';
import 'package:admin_desktop/presentation/styles/style.dart';
import 'package:flutter/material.dart';
import 'package:auto_route/auto_route.dart';
import 'package:flutter_riverpod/flutter_riverpod.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:admin_desktop/application/providers.dart';
import 'package:admin_desktop/infrastructure/services/utils.dart';
import 'package:admin_desktop/presentation/components/components.dart';
import 'package:admin_desktop/presentation/components/image/stories_image_picker.dart';
import 'package:admin_desktop/domain/models/models.dart';
import '../../../../../catalogue/widgets/service_master/widgets/services_modal.dart';
import '../widgets/products_modal.dart';

class CreateStoriesPage extends ConsumerStatefulWidget {
  const CreateStoriesPage({super.key});

  @override
  ConsumerState<CreateStoriesPage> createState() => _CreateStoriesPageState();
}

class _CreateStoriesPageState extends ConsumerState<CreateStoriesPage> {
  String _selectedType = 'product';

  ServiceData? service;

  List<String> types = ['product', 'service', 'shop'];

  @override
  void initState() {
    WidgetsBinding.instance.addPostFrameCallback((_) {
      ref.read(editStoriesProvider.notifier).setStoryDetails(null);
    });
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    final state = ref.watch(editStoriesProvider);
    final notifier = ref.read(editStoriesProvider.notifier);
    return KeyboardDisable(
      child: Container(
        margin: EdgeInsets.all(12),
        decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(AppConstants.radius),
        ),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            const HeaderItem(title: TrKeys.stories),
            Padding(
              padding: REdgeInsets.symmetric(horizontal: 16),
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  24.verticalSpace,
                  StoriesImagePicker(
                    listOfImages: state.images,
                    imageUrls: state.listOfUrls,
                    onImageChange: notifier.setImageFile,
                    onDelete: notifier.deleteImage,
                  ),
                  24.verticalSpace,
                  Row(
                    children: [
                      Text(
                        AppHelpers.getTranslation(TrKeys.storiesType),
                        style: Style.interMedium(size: 16),
                      ),
                      16.horizontalSpace,
                      DropdownButton<String>(
                        value: _selectedType,
                        items: [
                          ...types.map(
                            (e) => DropdownMenuItem(
                              value: e,
                              child: Text(AppHelpers.getTranslation(e)),
                            ),
                          ),
                        ],
                        onChanged: (value) {
                          setState(() {
                            _selectedType = value!;
                            state.textEditingController?.clear();
                          });
                        },
                      ),
                    ],
                  ),
                  24.verticalSpace,
                  if (_selectedType == 'product')
                    OutlinedBorderTextField(
                      readOnly: true,
                      label: AppHelpers.getTranslation(TrKeys.product),
                      textController: state.textEditingController,
                      onTap: () {
                        AppHelpers.showAlertDialog(
                          context: context,
                          child: SizedBox(
                            height: MediaQuery.sizeOf(context).height / 1.5,
                            width: MediaQuery.sizeOf(context).width / 3,
                            child: ProductsModal(),
                          ),
                        );
                      },
                    ),
                  if (_selectedType == 'service')
                    OutlinedBorderTextField(
                      readOnly: true,
                      label: AppHelpers.getTranslation(TrKeys.service),
                      textController: state.textEditingController,
                      onTap: () {
                        AppHelpers.showAlertDialog(
                          context: context,
                          child: SizedBox(
                            height: MediaQuery.sizeOf(context).height / 1.5,
                            width: MediaQuery.sizeOf(context).width / 3,
                            child: ServicesModal(
                              onChange: (service) {
                                state.textEditingController?.text =
                                    service.translation?.title ?? '';
                                service = service;
                              },
                            ),
                          ),
                        );
                      },
                    ),
                  if (_selectedType == 'shop') const SizedBox.shrink(),
                  104.verticalSpace,
                  Padding(
                    padding: REdgeInsets.symmetric(horizontal: 16),
                    child: Column(
                      mainAxisSize: MainAxisSize.min,
                      children: [
                        CustomButton(
                          title: AppHelpers.getTranslation(TrKeys.save),
                          isLoading: state.isLoading,
                          onTap: () {
                            if (state.listOfUrls.isEmpty &&
                                state.images.isEmpty) {
                              AppHelpers.errorSnackBar(
                                context,
                                text: TrKeys.imageCantEmpty,
                              );
                              return;
                            }
                            notifier.createStories(
                              context,
                              serviceId: _selectedType == TrKeys.service
                                  ? service?.id
                                  : null,
                              productId: _selectedType == TrKeys.product
                                  ? state.selectProduct?.id
                                  : null,
                              created: () {
                                ref
                                    .read(storiesProvider.notifier)
                                    .fetchStories(
                                      context: context,
                                      isRefresh: true,
                                    );
                                context.maybePop();
                              },
                            );
                          },
                        ),
                      ],
                    ),
                  ),
                ],
              ),
            ),
          ],
        ),
      ),
    );
  }
}
